# maya/scripts/qt_dev/matrix_ui.py
# Execute the following code in a python tab of Maya's script editor.
"""
import sys
sys.path.append('/Users/megan/Documents/maya/scripts/qt_dev/matrix_ui')

import matrix_ui as mui
reload(mui)
dialog = mui.MatrixDialog()
 
"""
from PySide2.QtGui import *
from PySide2.QtWidgets import *
from PySide2.QtCore import *
from PySide2.QtUiTools import *
from sliders import *
from armillarySphere import *

import matrix_tabs_ui
reload(matrix_tabs_ui)
  
import maya.cmds as cmds
  
class MatrixDialog(QDialog):
	# "__init__" is a special function that is automatically called 
	# by python when an instance of our DemoDialog class is created. 
	def __init__(self, parent=None):
		# Because our class is derived from QDialog its constructor is called.
		QDialog.__init__(self, parent)
		
		#this maintains a list of the particle transform node names
		self.matrix_transforms = []
		# Ensure our window stays in front and give it a title
		self.setWindowFlags(Qt.WindowStaysOnTopHint)
		self.setWindowTitle("Astrolabe Generator")
		self.setFixedSize(600, 400)
		
		# Create and assign the main (vertical) layout.
		vlayout = QVBoxLayout()
		self.setLayout(vlayout)    
		
		# We want to have the tabs at the top of the dialog
		self.addTabsPanel(vlayout)
		
		# We want to have the sliders at the top of the dialog
		#self.addSlidersPanel(vlayout)
		
		# Ensure the buttonPanel is pushed down to the lower edge of the
		# Dialog window.
		vlayout.addStretch()    
		self.addButtonPanel(vlayout)
		self.show()
	  #-------------------------------------------------------------
	def addTabsPanel(self, parentLayout):
		self.tabs = QTabWidget()
		page_1 = matrix_tabs_ui.RingsTabPage("Rings")
		page_2 = matrix_tabs_ui.PlanetsTabPage("Planets")
  		page_3 = matrix_tabs_ui.StarsTabPage("Stars")
		

		self.tabs.addTab(page_1, page_1.name)
		self.tabs.addTab(page_2, page_2.name)
		self.tabs.addTab(page_3, page_3.name)

		
		parentLayout.addWidget(self.tabs)
	
	  #-------------------------------------------------------------
	def addButtonPanel(self, parentLayout):
		# Add a Button and connect it to our custom buttonAction() method.
		self.okButton = QPushButton("Generate")
		#self.okButton.setEnabled(False)
		self.okButton.clicked.connect(self.createAction)
		
		self.deleteButton = QPushButton("Delete")
		self.deleteButton.setEnabled(False)
		self.deleteButton.clicked.connect(self.deleteAction)
	
		# For easthetics we add the button to a horizonal layout and use
		# stretch() to ensure it is pushed to the right hand edge.
		hlayout = QHBoxLayout()
		
		hlayout.addWidget(self.deleteButton)
		
		hlayout.addStretch()
		hlayout.addWidget(self.okButton)
		parentLayout.addLayout(hlayout)
	#--------------------------------------------------------------------
	def createAction(self):
		page = self.tabs.currentWidget()
		tnode = page.doAction()
		self.matrix_transforms.append(tnode)
		self.deleteButton.setEnabled(True)
	#--------------------------------------------------------------------
	def deleteAction(self):
		patterns = ["Ring", "Planet",  "Stars"]
		
		

		for p in patterns:
   			objects= cmds.ls("%s*" % p) 
  			cmds.delete(objects)
			self.deleteButton.setEnabled(False)



  
  
  
  
  
