# matrix_tabs_ui.py
from PySide2.QtGui import *
from PySide2.QtWidgets import *
from PySide2.QtCore import *
from PySide2.QtUiTools import *
from sliders import *
from armillarySphere import *



  
import maya.cmds as cmds
  
#===================================================================
# A generic base class from which specialized tab pages are derived. 
class AbstractTabPage(QWidget):
	def __init__(self, panelName):
		QWidget.__init__(self, None)
		self.name = panelName
		vlayout = QVBoxLayout()
		self.setLayout(vlayout)
		self.addWidgetsPanel(vlayout)
		vlayout.addStretch()
		self.setFocusPolicy( Qt.StrongFocus )
	#---------------------------------------------------------------
	def addWidgetsPanel(self, parentLayout):
		raise NotImplementedError("addWidgetsPanel() must be implemented")
	#---------------------------------------------------------------
	def doAction(self, parentLayout):
		raise NotImplementedError("doAction must be implemented")
	#---------------------------------------------------------------
	def focusOutEvent(self, event):
		# A derived class should implement this if they wish to
		# respond when a page loses focus.
		pass
	#---------------------------------------------------------------
	def focusInEvent(self, event):
		# A derived class should implement this if they wish to
		# respond when a page gains focus.
		pass
#===================================================================
class RingsTabPage(AbstractTabPage):
	def __init__(self, panelName):
		AbstractTabPage.__init__(self, panelName)
		# Note: the base class lays out the UI
	#-------------------------------------------------------------
	def addWidgetsPanel(self, parentLayout):
		vlayout = QVBoxLayout()

		self.numRingsSlider = IntSlider('Count', 1, 100, 7, vlayout)
		self.minradiusSlider = FloatSlider('Min Radius', 0.1, 100, 50, vlayout)
		self.widthSlider = FloatSlider('Width', 0.1, 20, 1, vlayout)
		self.randwidthSlider = FloatSlider('Width Variation', 0, 50, 8, vlayout)
		self.divSlider = IntSlider('Subdivisions', 3, 200, 80, vlayout)
		self.thickSlider = FloatSlider('Thickness', 0.1,20, 1, vlayout)
		self.separationSlider = FloatSlider('Separation', 0.1, 100, 15, vlayout)
		parentLayout.addLayout(vlayout)
	#-------------------------------------------------------------
	def doAction(self):
		print "ok"
		num = self.numRingsSlider.getValue()
		minradius = self.minradiusSlider.getValue()
		width = self.widthSlider.getValue()
		randwidth = self.randwidthSlider.getValue()
		div = self.divSlider.getValue()
		thick = self.thickSlider.getValue()
		separation = self.separationSlider.getValue()
		data = MakeArmillary(minradius, width, randwidth, div, thick, separation, num)
		#tnode = cmds.nParticle(p=data)[0]
	#	return tnode
	#-------------------------------------------------------------
	#===================================================================
class PlanetsTabPage(AbstractTabPage):
	def __init__(self, panelName):
		AbstractTabPage.__init__(self, panelName)
		# Note: the base class lays out the UI
	#-------------------------------------------------------------
	def addWidgetsPanel(self, parentLayout):
		vlayout = QVBoxLayout()
		
		self.radiusSlider = FloatSlider('Radius', 0.1, 50, 4, vlayout)
		self.randRadiusSlider = FloatSlider('Radius Variance', 0.1, 20,10, vlayout)
		self.sunScaleSlider = FloatSlider('Sun Scale', 0.1, 10, 1, vlayout)
	
		parentLayout.addLayout(vlayout)
	#-------------------------------------------------------------
	def doAction(self):
		print "ok"
		
		radius = self.radiusSlider.getValue()
		randRadius = self.randRadiusSlider.getValue()
		sunScale = self.sunScaleSlider.getValue()
		
		data = MakePlanets(radius, randRadius, sunScale)
		#tnode = cmds.nParticle(p=data)[0]
	#	return tnode
	#-------------------------------------------------------------
#===================================================================
class StarsTabPage(AbstractTabPage):
	def __init__(self, panelName):
		AbstractTabPage.__init__(self, panelName)
		# Note: the base class lays out the UI
	#-------------------------------------------------------------
	def addWidgetsPanel(self, parentLayout):
		vlayout = QVBoxLayout()
		self.numStarsSlider = IntSlider('Count', 1, 100, 25, vlayout)
		self.scaleSlider = FloatSlider('Scale', 0.1, 50, 1, vlayout)
		self.randScaleSlider = FloatSlider('Scale Variance', 0, 20, 2.5, vlayout)
		self.min_distSlider = FloatSlider('Min Distance', 0.1, 100, 70, vlayout)
		self.max_distSlider = FloatSlider('Max Distance', 1, 400, 200, vlayout)
		self.distSlider = FloatSlider('Distance', 0.1, 100, 10, vlayout)
	
		parentLayout.addLayout(vlayout)
	#-------------------------------------------------------------
	def doAction(self):
		print "ok"
		num = self.numStarsSlider.getValue()
		scale = self.scaleSlider.getValue()
		randScale = self.randScaleSlider.getValue()
		min_dist = self.min_distSlider.getValue()
		max_dist = self.max_distSlider.getValue()
		dist = self.distSlider.getValue()
		
		data = MakeStars(num, scale, randScale, min_dist, max_dist, dist)
		#tnode = cmds.nParticle(p=data)[0]
	#	return tnode
	#-------------------------------------------------------------
