"""
import armillarySphere as arm
reload(arm)
dialog = arm.MakeArmillary(radius, height, div, thick, sep, rotation, count)

dialog = arm.MakePlanets(radius, randRadius, sunScale)

dialog = arm.MakeStars(count, scale, randScale, min_dist, max_dist, dist)

"""
import maya.cmds as cmds
import random
import mesh_utils
import math

def MakeArmillary( minradius, width, randwidth, div, thick, separation, count):

	for x in range(0, count):
	
		
		cmds.polyPipe(radius=(minradius+(x*separation)), thickness = random.uniform(width, width + randwidth), height = thick, subdivisionsAxis=div, 
		subdivisionsCaps = 1, subdivisionsHeight =1, roundCap = 0, name = 'Ring1') #make rings
		x = random.uniform(0, 360)
		y = random.uniform(0, 360)
		z = random.uniform(0, 360)
		cmds.rotate(x, y, z)
		

	rings = cmds.select(['Ring%s' % n for n in range(1, count + 1)]) #select all rings to group
	cmds.group(name = 'Rings')
	


def MakePlanets(radius, randRadius, sunScale):
	
	allRings = []
	allRings = cmds.ls( "Ring*", recursive=True, geometry=True) #find number of rings that exist
	
	numElems = len(allRings)
	
	for i in range(1, numElems): # one planet per ring
		radiusPlanets = random.uniform(radius, radius + randRadius) 
		midpoints = mesh_utils.get_faces_midpoint(['Ring%s' % i], False)
		x,y,z = random.choice(midpoints)
		cmds.polySphere( r = radiusPlanets, name = 'Planet1' )
		cmds.move(x,y,z)
		
		
	cmds.select('sun1') #requires existing 'sun1' model
	cmds.scale(sunScale, sunScale, sunScale)
	planets = cmds.select(['Planet%s' % n for n in range(1, numElems)]) 
	cmds.group(name = 'Planets')



def MakeStars(count, scale, randScale, min_dist, max_dist, dist):
	if cmds.objExists( 'star_Armillary1'):
		dist = (min_dist + max_dist)/2
		for x in range(0, count):
			cmds.select(['star_Armillary%s' % (x+1)]) 
			cmds.duplicate()
			x = random.uniform(0, 360)
			y = random.uniform(0, 360)
			z = random.uniform(0, 360)
			cmds.rotate(x,y,z)
		for x in range(0, count):
			scaleStars = random.uniform(scale, (scale + randScale) )
			cmds.select(['star_Armillary%s' % (x +1)]) 
	
			cmds.scale( scaleStars, scaleStars, scaleStars)
		for x in range(0, count):  #randomly disperse stars
			xdist = random.uniform(min_dist, max_dist)

			xdist = random.uniform(-dist, dist)
			ydist = random.uniform(-dist, dist)
			zdist = random.uniform(-dist, dist)
			distance = math.sqrt(xdist * xdist + ydist * ydist + zdist * zdist )
			if distance >= min_dist and distance <= max_dist:
				cmds.select(['star_Armillary%s' % (x +1)]) 
				cmds.move(xdist ,ydist ,zdist )
	
			else:
				print "nope"
		stars = cmds.select(['star_Armillary%s' % n for n in range(1, count + 1)]) 
		cmds.group(name = 'Stars')
		cmds.select(['star_Armillary%s' % (count + 1)]) 
		cmds.delete() 
		
	else:
		print "Does no exist"






